/* Copyright (c) 2004, 2010, Oracle and/or its affiliates. 
All rights reserved. */

/*

   NAME
     select.c - <one-line expansion of the name>

   DESCRIPTION
     <short description of facility this file declares/defines>

   EXPORT FUNCTION(S)
     <external functions defined for use outside package - one-line description>

   INTERNAL FUNCTION(S)
     <other external functions defined - one-line descriptions>

   STATIC FUNCTION(S)
     <static functions defined - one-line descriptions>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
   navasthy    07/15/10 - [bug9910706]Revert changes in bug 8608552 
   navasthy    06/17/09 - Fix eno, bug 8608552
   sprabhak    08/06/07 - Fix bug 6319119
   mvasudev    03/29/07 - ifdef change
   sprabhak    02/16/05 - Fix for bug 4994424
   ardesai     03/04/05 - Include windows.h for windows platform.
   subanerj    06/06/04 - subanerj_odbc_env_setup
   ardesai     06/02/04 - Creation

*/

#ifdef WIN32COMMON
#include <windows.h>
#endif

#include <stdio.h>
#include <sql.h>
#include <sqlext.h>
#define  STR_LEN 50

int main (int argc, char *argv[])
{
  HENV          henv;          /* environment handle */
  HDBC          hdbc;          /* connection handle  */
  SQLHSTMT      hstmt;         /* statement handle   */
  SDWORD        retcode;       /* return code        */
  SQLCHAR *     stmt = "select ename, empno from emp where empno orderby empno";
  SQLCHAR       empname[STR_LEN] = "", job[STR_LEN];
  #ifdef _WIN64  
    SQLLEN enind,jind;
  #elif BUILD_REAL_64_BIT_MODE
    SQLLEN enind,jind;
  #else
    SQLINTEGER    enind, jind;
  #endif
  SQLUINTEGER   eno = 0;
  SQLCHAR       SqlState[6], Msg[SQL_MAX_MESSAGE_LENGTH];
  SQLINTEGER    NativeError;
  SQLSMALLINT   MsgLen;

  retcode = SQLAllocEnv (&henv);
  retcode = SQLSetEnvAttr (henv, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3,
              SQL_IS_INTEGER);
  retcode = SQLAllocConnect (henv, &hdbc);
  retcode = SQLConnect (hdbc, "TestDBDSN", SQL_NTS, "scott", SQL_NTS, "tiger",
              SQL_NTS);
  if (retcode != SQL_SUCCESS)
    {
      if ((retcode = SQLGetDiagRec (SQL_HANDLE_DBC, hdbc, 1, SqlState, 
                       &NativeError, Msg, sizeof (Msg), 
                       &MsgLen)) != SQL_NO_DATA)
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
      goto EXIT;
    }
  retcode = SQLAllocHandle (SQL_HANDLE_STMT, hdbc, &hstmt);
  SQLBindCol (hstmt, 1, SQL_C_CHAR, empname, sizeof (empname), &enind);
  SQLBindCol (hstmt, 2, SQL_C_ULONG, &eno, 0, &jind);

  SQLExecDirect (hstmt, "select ename, empno from emp", SQL_NTS);

  while ((retcode = SQLFetch (hstmt)) != SQL_NO_DATA)
    {
      if (enind == SQL_NULL_DATA)
        printf ("NULL  \n");
      else
        printf ("EMPNAME=%s ", empname);

      if (jind == SQL_NULL_DATA)
        printf ("NULL  \n");
      else
        printf ("EMPNO=%d\n", eno);
    }

EXIT:
  SQLFreeStmt (hstmt, SQL_CLOSE);
  SQLDisconnect (hdbc);
  SQLFreeConnect (hdbc);
  SQLFreeEnv (henv);
  return 0;
}


/* end of file select.c */
